<?php
/**
 * Bootstrap file.
 */

/**
 * Bootstrap.
 *
 * @author gabor
 */
chdir(dirname(__FILE__));

$classes = (include_once('../cache/classes.php')) + (include_once('../../../cache/classes.php'));

if (Request::hasGet('logDebug') || (defined('ENVIRONMENT') && ENVIRONMENT == 'DEV')) {
	error_reporting(E_ALL);
	ini_set('display_errors', '1');
}

include('../../../include/config/db_config.php');
include('config/config.php');

// Betolti az oldalt
Request::requireUri();

/**
 * Beltolti a szukseges osztalyokat.
 *
 * @param string $className   Osztaly nev.
 *
 * @return void
 */
function __autoload($className)
{
	global $classes;

	try {
		if (!empty($classes[$className]) && is_file('../' . $classes[$className])) {
			include('../' . $classes[$className]);
		}
		else {
			throw new Exception(
				'Nem talalhato a legeneralt osztalyok kozott: <b>' . $className . '</b> osztaly<br>' .
				(!empty($classes[$className]) ? 1 : 0) . ' - ' . (is_file('../' . $classes[$className]) ? 1 : 0));
		}
	}
	catch (Exception $e) {
		if ((defined('ENVIRONMENT') && ENVIRONMENT == 'DEV')) {
			$trace = $e->getTrace();
			echo sprintf(
				"<b>EXCEPTION:</b> %s<br>file: %s<br>sor: %s.<br><br>Hibas osztaly meghivasanak helye:<br>file: %s" .
				"<br> sor: %s",
				$e->getMessage(), $e->getFile(), $e->getLine(), $trace[0]['file'], $trace[0]['line']);
			exit(1);
		}
		else {
			error_log("Caught $e");
			Request::redirectToRout('Error/404', array(), array(), '#portal/bootstrap:-Hibas-osztaly-meghivas',
				'portal/bootstrap: Hibas osztaly meghivas: ' . $e->getMessage());
		}
	}
}