<?php
/**
 * CLI bootstrap.
 *
 * @author gabor
 */

/**
 * Beltolti a szukseges osztalyokat.
 *
 * @param string $className   Osztaly nev.
 */
if (!function_exists('__autoload')) {
	function __autoload($className)
	{
		$classes = (include('../cache/classes.php')) + (include('../../../cache/classes.php'));

		try {
			if (!empty($classes[$className]) && is_file('../' . $classes[$className])) {
				include('../' . $classes[$className]);
			}
			else {
				throw new Exception('Nem talalhato a legeneralt osztalyok kozott: <b>' . $className . '</b> osztaly');
			}
		}
		catch (Exception $e) {
			$trace = $e->getTrace();
			echo sprintf(
				"EXCEPTION: %s\nfile: %s\nsor: %s.\n\nHibas osztaly meghivasanak helye:\nfile: %s" .
				"\n sor: %s",
				$e->getMessage(), $e->getFile(), $e->getLine(), $trace[0]['file'], $trace[0]['line']);
			exit(1);
		}
	}
}

error_reporting(E_ALL);
ini_set('display_errors', '1');

if (!empty($argv[1]) && $argv[1] == 'DEV') {
	define('ENVIRONMENT', 'DEV');
	include('../../../include/config/dev_db_config.php');
}
elseif (!empty($argv[1]) && $argv[1] == 'AZURE_PROD') {
	define('ENVIRONMENT', 'AZURE_PROD');
	include('../../../include/config/db_config.php');
}
else {
	include('../../../include/config/db_config.php');
}

include('config/config.php');